using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CameraCollison : MonoBehaviour
{
    public float MinDistance = 1.0f;
    public float MaxDistance = 4.0f;
    public float Smooth = 10.0f;
    Vector3 dollyDir;
    public Vector3 DollyDirAdjusted;
    public float distance;
    // Start is called before the first frame update
    void Awake()
    {
        dollyDir = transform.localPosition.normalized;
        distance = transform.localPosition.magnitude;
    }

    // Update is called once per frame
    void Update()
    {
        Vector3 desiredCameraPos = transform.TransformPoint(dollyDir*MaxDistance);
        RaycastHit hit;
        if(Physics.Linecast (transform.position,desiredCameraPos, out hit))
        {
            distance = Mathf.Clamp(hit.distance*0.9f,MinDistance,MaxDistance);
        }
        else
        {
            distance = MaxDistance;
        }
        transform.localPosition = Vector3.Lerp(transform.localPosition,dollyDir * distance,Time.deltaTime*Smooth);
    }
}
